<?php if (statusModule('publish', 'podcasts') == 1) { ?>
    <?php $latestPodcasts = latestPodcasts($setting->latest_podcasts_l); ?>
    <?php if ($latestPodcasts) { ?>
        <section class="mb-3 col-md-<?php echo $widget->col; ?>">
            <h2 class="title"><?php echo $_LANG['latest-podcasts']; ?></h2>
            <div class="row">
                <?php foreach ($latestPodcasts as $podcast) { ?>
                    <article class="col-md-4 col-6">
                        <div class="card post1-card text-bg-dark">
                            <a class="link-post" href="<?php echo PATH_SYSTEM . "podcasts/view/" . $podcast->id . '-' . $podcast->url; ?>" aria-label="<?php echo $podcast->title; ?>"></a>
                            <img loading="lazy" src="<?php echo PATH_SYSTEM . "public/podcast/" . $podcast->thumbnail; ?>" class="card-img" alt="<?php echo $podcast->title; ?>">
                            <div class="card-img-overlay d-flex flex-column">
                                <h3 class="card-title mb-auto"><?php echo $podcast->title; ?></h3>
                                <p class="card-text"><small><?php echo elapsedTime($podcast->updated); ?></small></p>
                            </div>
                            <span class="button"><i class="fas fa-microphone-lines"></i></span>
                        </div>
                    </article>
                <?php } ?>
            </div>
        </section>
    <?php } ?>
<?php } ?>
